local _, ns = ...

ns.localization.profile = "Character-specific settings"
ns.localization.profileTooltip = "Switch between a profile that applies to all characters and one that is unique to this character."
ns.localization.credits = "Credits"
ns.localization.install = "Installer"
ns.localization.needReload = "You need to reload the UI to apply your changes."
ns.localization.needReloadPopup = "You need to reload the UI to apply your changes.\n\nWould you like to do so now?"
ns.localization.requiresReload = "Changing this option requires a UI reload."
ns.localization.reload = "Reload UI"
ns.localization.resetData = "Remove data"
ns.localization.resetDataTooltip = "Check to remove all saved data, such as how much money your characters have (which is used for the tooltip on the money in your bags)."
ns.localization.resetOptions = "Remove saved options"
ns.localization.resetOptionsTooltip = "Check to remove all saved options, and reset them to their default values."
ns.localization.resetCharBox = "Remove data for this character:"
ns.localization.layoutText = "Use the button below to switch to the other unitframe layout.\nYou can also use the '/freeui dps' or '/freeui heal' command."
ns.localization.notificationPreviewText = "This is an example of a notification."
ns.localization.notificationPreviewCallbackText = "Banner clicked! Most notifications have a relevant on-click action."
ns.localization.author = "FreeUI by Haleth on wowinterface.com"
ns.localization.authorSubText = "Lightsword @ Argent Dawn - EU"
ns.localization.NEW = "NEW!"

ns.localization.general = "General"
ns.localization.generalSubText = "These options control most of the common settings in the UI."
ns.localization.generalFeatures = "Features"
ns.localization.generalMisc = "Miscellaneous"
ns.localization.generalbuffreminder = "Buff reminder"
ns.localization.generalbuffreminderTooltip = "While in combat, show a reminder when missing important buffs that you can cast."
ns.localization.generalbuffTracker = "Buff tracker"
ns.localization.generalbuffTrackerTooltip = "Show important buffs below the center of the screen for certain classes."
ns.localization.generalcombatText = "Combat text"
ns.localization.generalcombatTextTooltip = "Show incoming damage and healing near the player frame."
ns.localization.generalhelmcloakbuttons = "Helm/Cloak buttons"
ns.localization.generalhelmcloakbuttonsTooltip = "Allows you to toggle Helm/Cloak display from the character frame."
ns.localization.generalinterrupt = "Interrupt announcer"
ns.localization.generalinterruptTooltip = "Announce your interrupts when in a raid group or arena, and/or under the circumstances below."
ns.localization.generalinterrupt_party = "Enable in party"
ns.localization.generalinterrupt_partyTooltip = "Enables interrupt announcing in 5-man groups and scenarios (the latter only when 'Enable in instance groups' is checked)."
ns.localization.generalinterrupt_bgs = "Enable in battlegrounds"
ns.localization.generalinterrupt_bgsTooltip = "Enables interrupt announcing in battlegrounds (both random groups and premades)."
ns.localization.generalinterrupt_lfg = "Enable in instance groups"
ns.localization.generalinterrupt_lfgTooltip = "Enables interrupt announcing in raid finder, dungeon finder and scenario finder groups."
ns.localization.generalinterrupt_outdoors = "Enable outdoors"
ns.localization.generalinterrupt_outdoorsTooltip = "Enables interrupt announcing when not in an instance."
ns.localization.generalmailButton = "Mail collection button"
ns.localization.generalmailButtonTooltip = "Adds a button to the mail frame to collect all mail attachments with one click."
ns.localization.generalnameplates = "Nameplates"
ns.localization.generalnameplatesTooltip = "Restyle the default nameplates. You may want to disable this option if you prefer another nameplate addon."
ns.localization.generalrareAlert = "Rare alert"
ns.localization.generalrareAlertTooltip = "Show a raid warning and play an optional sound when a rare creature or treasure is spotted. Check your minimap for the location."
ns.localization.generalrareAlert_playSound = "Play sound"
ns.localization.generalthreatMeter = "Threat meter"
ns.localization.generalthreatMeterTooltip = "Show a bar above the target frame that displays your threat compared to the tank as a dps, or the threat and name of the second highest in threat when tanking."
ns.localization.generaluiScaleAuto = "Force optimal UI scale"
ns.localization.generaluiScaleAutoTooltip = "Automatically apply the best UI scale for your resolution."
ns.localization.generalundressButton = "Undress button"
ns.localization.generalundressButtonTooltip = "Adds an undress button to the dressup frame. Useful when trying on shirts or chest armour."

ns.localization.appearance = "Appearance"
ns.localization.appearanceSubText = "You can change the appearance of various aspects of the UI here."
ns.localization.appearanceColours = "Colours"
ns.localization.appearanceFonts = "Fonts"
ns.localization.appearancecolourScheme = "Colour scheme"
ns.localization.appearancecolourScheme1 = "Class colour"
ns.localization.appearancecolourScheme2 = "Custom"
ns.localization.appearancecolourScheme1Tooltip = "Automatically change the colour scheme based on your character's class."
ns.localization.appearancecolourScheme2Tooltip = "Click the square to the right to choose a custom colour."
ns.localization.appearancechooseColour = "Choose..."
ns.localization.appearancefontUseAlternativeFont = "Use alternative font"
ns.localization.appearancefontUseAlternativeFontTooltip = "Replaces the default pixel font with the one used in the chat frame."
ns.localization.appearancefontSizeNormal = "Normal font size"
ns.localization.appearancefontSizeLarge = "Large font size"
ns.localization.appearancefontOutline = "Font outline"
ns.localization.appearancefontOutlineStyle = "Outline style"
ns.localization.appearancefontOutlineStyle1 = "Normal"
ns.localization.appearancefontOutlineStyle2 = "Monochrome"
ns.localization.appearancefontOutlineStyle1Tooltip = "Best used with regular fonts (not pixel fonts)."
ns.localization.appearancefontOutlineStyle2Tooltip = "Best used with pixel fonts."
ns.localization.appearancefontShadow = "Font shadow"
ns.localization.appearancesampleText = "sample SAMPLE"

ns.localization.automation = "Automation"
ns.localization.automationSubText = "With these features, the UI can perform common tasks automatically."
ns.localization.automationautoAccept = "Accept invites from friends and guild members"
ns.localization.automationautoRepair = "Repair items"
ns.localization.automationautoRepair_guild = "Use guild funds when available"
ns.localization.automationautoRoll = "Roll disenchant or greed on BoE uncommon items"
ns.localization.automationautoRoll_maxLevel = "Only at max level"
ns.localization.automationautoSell = "Sell junk"
ns.localization.automationautoSellTooltip = "Automatically sell grey quality items to vendors, unless they are used in an equipment set."
ns.localization.automationquestRewardHighlight = "Quest reward highlighting"
ns.localization.automationquestRewardHighlightTooltip = "When turning in a quest, highlight the quest reward with the highest vendor sell price."
ns.localization.automationautoSetRole = "Skip unnecessary role poll popups"
ns.localization.automationautoSetRoleTooltip = "Skip the role poll popup if your role is already set or you are playing a pure dps class."
ns.localization.automationautoSetRole_useSpec = "Set role based on current specialization"
ns.localization.automationautoSetRole_useSpecTooltip = "Always attempt to set your role automatically based on your spec, never showing the popup."
ns.localization.automationautoSetRole_verbose = "Verbose mode"
ns.localization.automationautoSetRole_verboseTooltip = "Enable to be informed of what happens when the popup is skipped."

ns.localization.actionbars = "Action bars"
ns.localization.actionbarsSubText = "These options are specific to the action bars and their buttons."
ns.localization.actionbarsenable = "Enable"
ns.localization.actionbarsenableTooltip = "Disable this option if you want to use another action bars addon."
ns.localization.actionbarsenableStyle = "Enable button style"
ns.localization.actionbarsenableStyleTooltip = "You may need to disable this option to ensure compatibility with other action bars addons."
ns.localization.actionbarshotkey = "Show key bindings on buttons"
ns.localization.actionbarsrightbars_mouseover = "Show right action bars on mouseover"

ns.localization.bags = "Bags"
ns.localization.bagsSubText = "Choose and customize a bag style of your liking."
ns.localization.bagsGeneral = "General"
ns.localization.bagsStyleSpecific = "Style-specific"
ns.localization.bagssize = "Bag size"
ns.localization.bagsstyle = "Bag style"
ns.localization.bagsstyle1 = "All-in-one"
ns.localization.bagsstyle2 = "Restyle default"
ns.localization.bagsstyle3 = "Disable"
ns.localization.bagsslotsShowAlways = "Always show item slots"
ns.localization.bagsslotsShowAlwaysTooltip = "Enable to show the border of empty bag slots even when not moving any items."
ns.localization.bagshideSlots = "Hide bag slots"
ns.localization.bagshideSlotsTooltip = "Disable this option when you want to add or a replace a bag."

ns.localization.menubar = "Menu bar"
ns.localization.menubarSubText = "The menu bar is the panel at the bottom of the screen. Moving your mouse over it reveals additional functionality and information."
ns.localization.menubarenable = "Enable"
ns.localization.menubarenableButtons = "Enable buttons"
ns.localization.menubarenableButtonsTooltip = "Show buttons on the menu bar."
ns.localization.menubarbuttons_mouseover = "Show buttons on mouseover"
ns.localization.menubarbuttons_mouseoverTooltip = "Only show the buttons when moving the cursor over the menu bar."

ns.localization.notifications = "Notifications"
ns.localization.notificationsSubText = "These options let you choose when and how the UI should show notifications."
ns.localization.notificationsWhen = "When"
ns.localization.notificationsHow = "How"
ns.localization.notificationsPreview = "Preview"
ns.localization.notificationsenable = "Enable"
ns.localization.notificationsenableTooltip = "Allow notifications to be shown. A banner will appear at the top of the UI. Clicking it with either mouse button dismisses the notifications. Clicking it with the left button can also perform an action, such as showing the calendar."
ns.localization.notificationsplaySounds = "Play sounds"
ns.localization.notificationsplaySoundsTooltip = "Play a sound when a notification is shown."
ns.localization.notificationsanimations = "Animations"
ns.localization.notificationsanimationsTooltip = "Animate the banner when it is shown or hidden."
ns.localization.notificationstimeShown = "Time shown"
ns.localization.notificationscheckEvents = "Calendar events"
ns.localization.notificationscheckEventsTooltip = "Show a notification when you have pending calendar events."
ns.localization.notificationscheckGuildEvents = "Guild events"
ns.localization.notificationscheckGuildEventsTooltip = "Show a notification when you have pending guild events. These events do not appear on your calendar button by default and are easily missed."
ns.localization.notificationscheckMail = "Mail"
ns.localization.notificationscheckMailTooltip = "Show a notification when you have new mail."
ns.localization.notificationscheckBagsFull = "Bags full"
ns.localization.notificationscheckBagsFullTooltip = "Show a notification when your bags are full."

ns.localization.unitframes = "Unit frames"
ns.localization.unitframesSubText = "These options control most of the options for the unit frames. If you want to move the unit frames easily, install oUF_MovableFrames."
ns.localization.unitframesenable = "Enable"
ns.localization.unitframesenableTooltip = "Disable this option if you want to use another unit frames addon."
ns.localization.unitframesautoPosition = "Automatically position"
ns.localization.unitframesautoPositionTooltip = "Position the unit frames automatically based on screen resolution. Disable if you want to manually position them in the options file."
ns.localization.unitframesenableGroup = "Party/Raid frames"
ns.localization.unitframesenableGroupTooltip = "Uncheck if you want to use another addon for party and raid frames."
ns.localization.unitframesshowRaidFrames = "Show raid frames"
ns.localization.unitframesshowRaidFramesTooltip = "When disabled, show only the party frames, even in a raid group."
ns.localization.unitframespartyNameAlways = "Always show group member names"
ns.localization.unitframespartyNameAlwaysTooltip = "Check to show group member names in the dps/tank layout."
ns.localization.unitframescastbarSeparate = "Player castbar as separate bar"
ns.localization.unitframescastbarSeparateTooltip = "When this option is disabled, the player cast bar is embedded in the player frame."
ns.localization.unitframescastbarSeparateOnlyCasters = "Only for caster classes"
ns.localization.unitframescastbarSeparateOnlyCastersTooltip = "Check to only use the separate cast bar as a Mage, Priest, or Warlock."
ns.localization.unitframesabsorb = "Absorb amount"
ns.localization.unitframesabsorbTooltip = "Shows absorb amounts as well as an over-absorb glow on unit frames."
ns.localization.unitframestargettarget = "Target of Target"
ns.localization.unitframestargettargetTooltip = "Add a Target of Target frame above the target frame."
ns.localization.unitframeshealerClasscolours = "Always use class colours"
ns.localization.unitframeshealerClasscoloursTooltip = "Enable to use class colours rather than gradient in the healer layout."
ns.localization.unitframespvp = "PVP icon"
ns.localization.unitframespvpTooltip = "Show a small red PVP icon above the player unit frame."

ns.localization.unitframesstatusIndicator = "Status indicator"
ns.localization.unitframesstatusIndicatorTooltip = "Show resting and combat (if enabled) status on the player frame."
ns.localization.unitframesstatusIndicatorCombat = "Combat status"
ns.localization.unitframesstatusIndicatorCombatTooltip = "Show combat status on the indicator. If disabled, only resting status is shown."

ns.localization.unitframesenableArena = "Arena/Flag Carrier frames"
ns.localization.unitframesenableArenaTooltip = "Enables unit frames for arena enemies (including round preparation) and flag carriers in battlegrounds."

ns.localization.tooltip = "Tooltip"
ns.localization.tooltipSubText = "Adjust the appearance and functionality of the game tooltip below."
ns.localization.tooltipenable = "Enable"
ns.localization.tooltipenableTooltip = "Disable to resolve compatibility issues or if you want to use another tooltip addon."
ns.localization.tooltipanchorCursor = "Anchor to cursor"
ns.localization.tooltipclass = "Class"
ns.localization.tooltipguildrank = "Guild rank"
ns.localization.tooltiptitle = "Player titles"
ns.localization.tooltippvp = "PvP status"

ns.localization.classmod = "Class specific"
ns.localization.classmodSubText = "These options allow you to toggle the class-specific modules in the UI."

local classes = UnitSex("player") == 2 and LOCALIZED_CLASS_NAMES_MALE or LOCALIZED_CLASS_NAMES_FEMALE

for class, localized in pairs(classes) do
	ns.localization["classmod"..strlower(class)] = localized
end

ns.localization.classmoddeathknight = ns.localization.classmoddeathknight..":|cffffffff Rune bars"
ns.localization.classmoddruidMana = ns.localization.classmoddruid..":|cffffffff Shapeshift mana bar"
ns.localization.classmoddruidEclipse = ns.localization.classmoddruid..":|cffffffff Eclipse bar"
ns.localization.classmodmage = ns.localization.classmodmage..":|cffffffff Rune of Power tracker"
ns.localization.classmodmonk = ns.localization.classmodmonk..":|cffffffff Chi and Stagger tracker"
ns.localization.classmodpaladinHP = ns.localization.classmodpaladin..":|cffffffff Holy Power tracker"
ns.localization.classmodpaladinRF = ns.localization.classmodpaladin..":|cffffffff Righteous Fury reminder"
ns.localization.classmodpriest = ns.localization.classmodpriest..":|cffffffff Shadow orb tracker"
ns.localization.classmodwarlock = ns.localization.classmodwarlock..":|cffffffff Specialization bars"

ns.localization.credits = "Credits"
ns.localization.thankYou = "Thank you:"
ns.localization.alza = "For AlzaUI, which once formed the basis for FreeUI"
ns.localization.haste = "For the oUF framework, the foundation of the unit frames in this UI"
ns.localization.tukz = "For allowing the use of his code, and collaboration in UI development"
ns.localization.zork = "For rActionBarStyler, rActionButtonStyler, and rBuffFrameStyler"
ns.localization.others = "as well as..."